/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.api.VWValidationError;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWValidationErrorListCellRenderer;
import filenet.vw.toolkit.design.message.images.VWImageLoader;
import filenet.vw.toolkit.design.message.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class VWSIMWorkflowValidationResultsDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private JLabel m_errorCountLabel = null;
    private JLabel m_warningCountLabel = null;
    private JComboBox m_errorComboBox = null;
    private JLabel m_levelLabel = null;
    private JLabel m_typeLabel = null;
    private JLabel m_displayingLabel = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JTextArea m_messageTextArea = null;
    private JTextArea m_informationTextArea = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private Integer m_nErrorCount = null;

    public VWSIMWorkflowValidationResultsDialog(Frame parentFrame) {
        super(parentFrame);
        this.init();
    }

    public VWSIMWorkflowValidationResultsDialog(Dialog parentDialog) {
        super(parentDialog);
        this.init();
    }

    public void windowClosing(WindowEvent event) {
        this.performExitItemAction(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_errorComboBox)) {
            this.handleComboBoxSelection();
        } else if (source.equals(this.m_upButton)) {
            this.handleUpButtonClick();
        } else if (source.equals(this.m_downButton)) {
            this.handleDownButtonClick();
        } else if (source.equals(this.m_closeButton)) {
            this.setVisible(false);
        } else if (source.equals(this.m_helpButton)) {
            VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "workflowvalidationresultsdialog.htm");
        }
    }

    protected void init() {
        this.setTitle(VWSIMResource.s_workflowValidationResultsTitle);
        Dimension dim = VWStringUtils.stringToDimension(VWSIMResource.s_workflowValidationResultsDialogDim);
        if (dim == null) {
            dim = new Dimension(475, 375);
        }
        this.setSize(dim);
        this.createControls();
        this.addWindowListener(new VWWindowAdapter(this));
    }

    protected void displayValidationMessages(VWValidationError[] errors) {
        DefaultComboBoxModel<VWValidationError> cbModel = new DefaultComboBoxModel<VWValidationError>(errors);
        this.m_errorComboBox.setModel(cbModel);
        int nErrorCount = 0;
        int nWarningCount = 0;
        this.m_nErrorCount = new Integer(0);
        if (errors != null) {
            this.m_nErrorCount = new Integer(errors.length);
            block4: for (int i = 0; i < errors.length; ++i) {
                switch (errors[i].getLevel()) {
                    case 1: {
                        ++nErrorCount;
                        continue block4;
                    }
                    case 2: {
                        ++nWarningCount;
                    }
                }
            }
        }
        this.m_errorCountLabel.setText(Integer.toString(nErrorCount));
        this.m_warningCountLabel.setText(Integer.toString(nWarningCount));
        if (cbModel.getSize() > 0) {
            this.m_errorComboBox.setSelectedIndex(0);
        }
        this.setVisible(true);
    }

    private void createControls() {
        this.getContentPane().setLayout(new BorderLayout(4, 4));
        JPanel panel = this.createTopPanel();
        if (panel != null) {
            this.getContentPane().add((Component)panel, "First");
        }
        if ((panel = this.createMainPanel()) != null) {
            this.getContentPane().add((Component)panel, "Center");
        }
        if ((panel = this.createButtonPanel()) != null) {
            this.getContentPane().add((Component)panel, "Last");
        }
    }

    private JPanel createTopPanel() {
        try {
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            topPanel.add((Component)new JLabel(VWResource.s_numberOfErrors), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_errorCountLabel = new JLabel("0");
            topPanel.add((Component)this.m_errorCountLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            topPanel.add((Component)new JLabel(VWResource.s_numberOfWarnings), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_warningCountLabel = new JLabel("0");
            topPanel.add((Component)this.m_warningCountLabel, gbCons);
            return topPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            mainPanel.add((Component)this.createPanelOne(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            mainPanel.add((Component)this.createPanelTwo(), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            mainPanel.add((Component)this.createPanelThree(), gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelOne() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel(VWResource.s_nameColon), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_errorComboBox = new JComboBox();
            this.m_errorComboBox.setRenderer(new VWValidationErrorListCellRenderer());
            this.m_errorComboBox.addActionListener(this);
            panel.add((Component)this.m_errorComboBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_level)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_levelLabel = new JLabel();
            panel.add((Component)this.m_levelLabel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_type)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_typeLabel = new JLabel();
            panel.add((Component)this.m_typeLabel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_displaying)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_displayingLabel = new JLabel();
            panel.add((Component)this.m_displayingLabel, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelTwo() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_upButton = VWImageLoader.createIconButton("up.gif", VWResource.s_up);
            this.m_upButton.addActionListener(this);
            buttonPanel.add((Component)this.m_upButton, gbCons);
            ++gbCons.gridy;
            this.m_downButton = VWImageLoader.createIconButton("down.gif", VWResource.s_down);
            this.m_downButton.addActionListener(this);
            buttonPanel.add((Component)this.m_downButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelThree() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_message)), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.7;
            this.m_messageTextArea = new JTextArea();
            this.m_messageTextArea.setLineWrap(true);
            this.m_messageTextArea.setWrapStyleWord(true);
            this.m_messageTextArea.setEditable(false);
            panel.add((Component)new JScrollPane(this.m_messageTextArea), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_information)), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.3;
            this.m_informationTextArea = new JTextArea();
            this.m_informationTextArea.setLineWrap(true);
            this.m_informationTextArea.setWrapStyleWord(true);
            this.m_informationTextArea.setEditable(false);
            panel.add((Component)new JScrollPane(this.m_informationTextArea), gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            ++gbCons.gridx;
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.addActionListener(this);
            buttonPanel.add((Component)this.m_closeButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleComboBoxSelection() {
        VWValidationError error = (VWValidationError)this.m_errorComboBox.getSelectedItem();
        if (error != null) {
            String tmpStr = null;
            switch (error.getLevel()) {
                case 1: {
                    tmpStr = VWResource.s_error;
                    break;
                }
                case 2: {
                    tmpStr = VWResource.s_warning;
                }
            }
            this.m_levelLabel.setText(tmpStr);
            switch (error.getErrorType()) {
                case 4: {
                    tmpStr = VWResource.s_field;
                    break;
                }
                case 7: {
                    tmpStr = VWResource.s_instruction;
                    break;
                }
                case 8: {
                    tmpStr = VWResource.s_milestone;
                    break;
                }
                case 3: {
                    tmpStr = VWResource.s_parameter;
                    break;
                }
                case 10: {
                    tmpStr = VWResource.s_partnerLink;
                    break;
                }
                case 2: {
                    tmpStr = VWResource.s_route;
                    break;
                }
                case 9: {
                    tmpStr = VWResource.s_ruleSet;
                    break;
                }
                case 11: {
                    tmpStr = VWResource.s_schema;
                    break;
                }
                case 1: {
                    tmpStr = VWResource.s_step;
                    break;
                }
                case 6: {
                    tmpStr = VWResource.s_workflow;
                }
            }
            this.m_typeLabel.setText(tmpStr);
            int nIndex = this.m_errorComboBox.getSelectedIndex() + 1;
            this.m_displayingLabel.setText(VWResource.s_nofm.toString(new Integer(nIndex), this.m_nErrorCount));
            this.m_messageTextArea.setText(error.getMessage());
            this.m_informationTextArea.setText(error.getInfo());
        }
        this.updateButtonState();
    }

    private void handleUpButtonClick() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        this.m_errorComboBox.setSelectedIndex(nIndex - 1);
        this.updateButtonState();
    }

    private void handleDownButtonClick() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        this.m_errorComboBox.setSelectedIndex(nIndex + 1);
        this.updateButtonState();
    }

    private void updateButtonState() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        if (nIndex == 0) {
            this.m_upButton.setEnabled(false);
        } else {
            this.m_upButton.setEnabled(true);
        }
        if (nIndex == this.m_errorComboBox.getModel().getSize() - 1) {
            this.m_downButton.setEnabled(false);
        } else {
            this.m_downButton.setEnabled(true);
        }
    }

    private void performExitItemAction(boolean bCloseWindow) {
        if (bCloseWindow) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
        }
    }
}

